#!/usr/bin/env python3

import os, sys, argparse

h_templ = '''#pragma once

int %s();
'''

c_templ = '''#include"%s.h"

int %s() {
    return 0;
}
'''

parser = argparse.ArgumentParser()
parser.add_argument('--searchdir', required=True)
parser.add_argument('--outdir', required=True)
parser.add_argument('ifiles', nargs='+')

options = parser.parse_args()

searchdir = options.searchdir
outdir = options.outdir
ifiles = options.ifiles

rel_ofiles = []

for ifile in ifiles:
    if not ifile.startswith(options.searchdir):
        sys.exit('Input file %s does not start with search dir %s.' % (ifile, searchdir))
    rel_ofile = ifile[len(searchdir):]
    if rel_ofile[0] == '/' or rel_ofile[0] == '\\':
        rel_ofile = rel_ofile[1:]
    rel_ofiles.append(os.path.splitext(rel_ofile)[0])

ofile_bases = [os.path.join(outdir, i) for i in rel_ofiles]

for i, ifile_name in enumerate(ifiles):
    proto_name = open(ifile_name).readline().strip()
    h_out = ofile_bases[i] + '.h'
    c_out = ofile_bases[i] + '.c'
    os.makedirs(os.path.split(ofile_bases[i])[0], exist_ok=True)
    open(h_out, 'w').write(h_templ % (proto_name))
    open(c_out, 'w').write(c_templ % (proto_name, proto_name))
